/*
 * @(#)CERAttribute.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.model;

import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import java.beans.*;
import javax.swing.event.*;
import java.util.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
/**
 * Represents an Attribute element in a Conceptual Entity-Relationship Model.
 * 
 * @author Werner Randelshofer
 * @version 1.0 6. Februar 2004  Created.
 */
public class CERAttribute extends AbstractElement
        implements DOMStorable {
    private String name;
    private boolean isPrimaryKey;
    private boolean isIdentifying;
    private boolean isMultivalued;
    private boolean isDerived;
    private boolean isDiscriminating;
    
    public CERAttribute() {
        ResourceBundleUtil labels = ConceptualERModel.labels;
        name = labels.getString("attributeDefaultName");
    }
    
    public void setPrimaryKey(boolean newValue) {
        boolean oldValue = isPrimaryKey;
        isPrimaryKey = newValue;
        firePropertyChange("primaryKey", oldValue, newValue);
    }
    public boolean isPrimaryKey() {
        return isPrimaryKey;
    }
    public void setIdentifying(boolean newValue) {
        boolean oldValue = isIdentifying;
        isIdentifying = newValue;
        firePropertyChange("identifying", oldValue, newValue);
    }
    public boolean isIdentifying() {
        return isIdentifying;
    }
    public void setDerived(boolean newValue) {
        boolean oldValue = isDerived;
        isDerived = newValue;
        firePropertyChange("derived", oldValue, newValue);
    }
    public boolean isDerived() {
        return isDerived;
    }
    public void setDiscriminating(boolean newValue) {
        boolean oldValue = isDiscriminating;
        isDiscriminating = newValue;
        firePropertyChange("discriminating", oldValue, newValue);
    }
    public boolean isDiscriminating() {
        return isDiscriminating;
    }
    public void setMultivalued(boolean newValue) {
        boolean oldValue = isMultivalued;
        isMultivalued = newValue;
        firePropertyChange("multivalued", oldValue, newValue);
    }
    public boolean isMultivalued() {
        return isMultivalued;
    }
    public void setName(String newValue) {
        String oldValue = name;
        name = newValue;
        firePropertyChange("name", oldValue, newValue);
    }
    public String getName() {
        return name;
    }
    
    public void read(DOMInput in) {
        name = in.getAttribute("name", "Attribute");
        isPrimaryKey = in.getAttribute("pk", false);
        isIdentifying = in.getAttribute("identifying", false);
        isDerived = in.getAttribute("derived", false);
        isDiscriminating = in.getAttribute("discriminating", false);
        isMultivalued = in.getAttribute("multivalued", false);
    }
    
    public void write(DOMOutput out) {
        out.addAttribute("name", name);
        out.addAttribute("pk", isPrimaryKey, false);
        out.addAttribute("identifying", isIdentifying, false);
        out.addAttribute("derived", isDerived, false);
        out.addAttribute("discriminating", isDiscriminating, false);
        out.addAttribute("multivalued", isMultivalued, false);
    }
    
    public int getSimulatedConcept() {
        return ConceptualERModel.ATTRIBUTE;
    }
    
    public boolean isEquivalent(SimulatedObject o) {
        if (super.isEquivalent(o) && (o instanceof CERAttribute)) {
            CERAttribute that = (CERAttribute) o;
            
            if (that.isPrimaryKey() == this.isPrimaryKey() &&
                    that.isIdentifying() == this.isIdentifying() &&
                    that.isDerived() == this.isDerived() &&
                    that.isDiscriminating() == this.isDiscriminating() &&
                    that.isMultivalued() == this.isMultivalued()) {
                return true;
            }
        }
        return false;
    }
}
